 ; Ŀ
 ;   Ccut - insert a block on the intersection of two or more lines, cut   
 ;   an appropriate sized chunk out of each one.                           
 ;   Copyright 1994, 2000, 2010 by Rocket Software Ltd.                    
 ;   Why are there sugar cubes but no milk cubes?                          
 ; 
 (DEFUN C:CCUT (/ rota rrota scal pa pb pc pasav ss xa xb num)
  (setq name (getstring))
  (setq dist (getdist))
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Try to load Misps.lsp, which contains the subroutines for scaling     
 ;   differently in model and paper space.                                 
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Get the scale, depending on the current space, fail gracefully.       
 ; 
  (if misps
      (setq scal (misps))
      (setq scal (getvar "dimscale")))
  (setq dist (* dist scal))
  (setq pa (getpoint "Insertion point:"))
  (setq pb (osnap pa "Intersec"))         ; look for an intersection
  (if pb (setq pa pb)                     ; if an intersec, use it
         (setq pc (osnap pa "nearest")))  ; if no int found, try for nearest
  (if pc (setq pa pc))                    ; if a nearest, go for it
  (setq pasav pa)
  (setq num 0)
 ; Ŀ
 ;   The counter is to prevent endless loops, which I think are fixed ...  
 ;   Actually this code seems to work ok and is simple and elegant, but    
 ;   there is a certain paranoid appeal in going to an overkill solution   
 ;   based on Cutup.lsp.  Consider this to be a tentative solution.        
 ; 
  (while (and (setq ss (ssget pasav '((-4 . "<or") (0 . "polyline")
                                      (0 . "line") (0 . "lwpolyline")
                                      (-4 . "or>"))))
              (< num 10))
         (setq num (1+ num))
         (setq enam (ssname ss 0))
         (setq pb (osnap pasav "end"))
         (if (equal pasav pb)
             (setq pa (osnap pasav "mid"))
             (setq pa pasav))
         (setq angg (angle pa pb))
         (setq xa (polar pasav angg dist))
         (setq xb (polar pasav angg (- dist)))
         (if (ssget xa '((-4 . "<or") (0 . "polyline") (0 . "line")
                         (0 . "lwpolyline") (-4 . "or>")))
             (command "break" xa xb)
             (command "break" xb xa)))
  (command "insert" name pasav scal "" 0) ; insert, no rotation
 (princ))